@extends('layouts/basic')

{{-- Add center login CSS --}}
@push('css')
<link rel="stylesheet" href="{{ asset('css/center-login.css') }}">
@endpush

{{-- Inline CSS to override any conflicting styles --}}
<style>
/* Force login box width and centering */
body.hold-transition.login-page .login-box, 
body.hold-transition.login-page .register-box {
    margin: 10% auto !important;
    width: 460px !important;
    max-width: 460px !important;
    box-shadow: 9px 9px 9px 9px rgb(32 32 29 / 10%) !important;
    border-radius: 20px !important;
}

/* Force box styling */
body.hold-transition.login-page .box {
    background: #fff !important;
    border-radius: 20px !important;
    border-top: 3px solid #d2d6de !important;
    box-shadow: 9px 9px 9px 9px rgb(32 32 29 / 10%) !important;
    margin-bottom: 20px !important;
    position: relative !important;
    width: 100% !important;
}

/* Force input group styling */
body.hold-transition.login-page .input-group {
    position: relative !important;
    display: flex !important;
    width: 100% !important;
}

body.hold-transition.login-page .input-group-addon {
    background-color: #f8f9fa !important;
    border: 1px solid #ced4da !important;
    border-radius: 12px 0 0 12px !important;
    padding: 10px 12px !important;
    display: flex !important;
    align-items: center !important;
    justify-content: center !important;
    min-width: 45px !important;
}

body.hold-transition.login-page .input-group .form-control {
    border-radius: 0 12px 12px 0 !important;
    border-left: none !important;
}

body.hold-transition.login-page .password-toggle {
    border-radius: 0 12px 12px 0 !important;
    border-left: none !important;
}

/* Style the horizontal rule */
body.hold-transition.login-page .box-header hr {
    border: none !important;
    height: 2px !important;
    background: linear-gradient(90deg, transparent, #3498db, transparent) !important;
    margin: 15px 0 10px 0 !important;
    border-radius: 1px !important;
}

/* Force Font Awesome icons to be visible */
body.hold-transition.login-page .fas,
body.hold-transition.login-page .fa,
body.hold-transition.login-page .far,
body.hold-transition.login-page .fab {
    font-family: "Font Awesome 6 Free" !important;
    font-weight: 900 !important;
    display: inline-block !important;
    font-style: normal !important;
    font-variant: normal !important;
    text-rendering: auto !important;
    -webkit-font-smoothing: antialiased !important;
    -moz-osx-font-smoothing: grayscale !important;
}
</style>

{{-- Page content --}}
@section('content')

    <form role="form" action="{{ url('/login') }}" method="POST" autocomplete="{{ (config('auth.login_autocomplete') === true) ? 'on' : 'off'  }}" class="modern-login-form">
        <input type="hidden" name="_token" value="{{ csrf_token() }}" />

        <!-- this is a hack to prevent Chrome from trying to autocomplete fields -->
        <input type="text" name="prevent_autofill" id="prevent_autofill" value="" style="display:none;" aria-hidden="true">
        <input type="password" name="password_fake" id="password_fake" value="" style="display:none;" aria-hidden="true">

        <div class="container">
            <div class="row">

                <div class="col-md-4 col-md-offset-4">

                    @if (($snipeSettings->google_login=='1') && ($snipeSettings->google_client_id!='') && ($snipeSettings->google_client_secret!=''))

                        <br><br>
                        <a href="{{ route('google.redirect')  }}" class="btn btn-block btn-social btn-google btn-lg">
                            <i class="fa-brands fa-google"></i>
                            {{ trans('auth/general.google_login') }}
                        </a>

                        <div class="separator">{{ strtoupper(trans('general.or')) }}</div>
                    @endif


                    <div class="box login-box">
                        <div class="box-header with-border">
                            <h1 class="box-title">
                                <i class="fas fa-cogs" style="margin-right: 10px; color: #3498db; font-size: 20px;"></i>
                                Asset Management Login Portal
                               
                            </h1>
                            <hr>
                            <p style="margin: 10px 0 0; color: #6c757d; font-size: 14px; text-align: center;">
                                Welcome back! Please sign in to your account.
                            </p>
                        </div>

                        <div class="login-box-body">
                            <div class="row">

                                @if ($snipeSettings->login_note)
                                    <div class="col-md-12">
                                        <div class="alert alert-info">
                                            {!!  Helper::parseEscapedMarkedown($snipeSettings->login_note)  !!}
                                        </div>
                                    </div>
                                @endif

                                <!-- Notifications -->
                                @include('notifications')

                                @if (!config('app.require_saml'))
                                <div class="col-md-12">
                                    <!-- CSRF Token -->


                                    <fieldset>

                                        <div class="form-group{{ $errors->has('username') ? ' has-error' : '' }}">
                                            <label for="username" class="form-label">
                                                <i class="fas fa-user-circle" style="margin-right: 8px; color: #3498db;"></i>
                                                Username
                                            </label>
                                            <div class="input-group">
                                                <span class="input-group-addon">
                                                    <i class="fas fa-user" style="color: #6c757d;"></i>
                                                </span>
                                                <input class="form-control" placeholder="Enter your username" name="username" type="text" id="username" autocomplete="{{ (config('auth.login_autocomplete') === true) ? 'on' : 'off'  }}" autofocus>
                                            </div>
                                            {!! $errors->first('username', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-exclamation-triangle" aria-hidden="true"></i> :message</span>') !!}
                                        </div>
                                        <div class="form-group{{ $errors->has('password') ? ' has-error' : '' }}">
                                            <label for="password" class="form-label">
                                                <i class="fas fa-key" style="margin-right: 8px; color: #3498db;"></i>
                                                Password
                                            </label>
                                            <div class="input-group">
                                                <span class="input-group-addon">
                                                    <i class="fas fa-lock" style="color: #6c757d;"></i>
                                                </span>
                                                <input class="form-control" placeholder="Enter your password" name="password" type="password" id="password" autocomplete="{{ (config('auth.login_autocomplete') === true) ? 'on' : 'off'  }}">
                                                <span class="input-group-addon password-toggle" style="cursor: pointer;" onclick="togglePassword()">
                                                    <i class="fas fa-eye" id="passwordToggleIcon" style="color: #6c757d;"></i>
                                                </span>
                                            </div>
                                            {!! $errors->first('password', '<span class="alert-msg" aria-hidden="true"><i class="fas fa-exclamation-triangle" aria-hidden="true"></i> :message</span>') !!}
                                        </div>
                                        <div class="form-group">
                                            <label class="checkbox-label">
                                                <input name="remember" type="checkbox" value="1" class="remember-checkbox">
                                                <i class="fas fa-check-square" style="margin-right: 8px; color: #3498db;"></i>
                                                Remember Me
                                            </label>
                                        </div>
                                    </fieldset>
                                </div> <!-- end col-md-12 -->
                                @endif
                            </div> <!-- end row -->

                            @if (!config('app.require_saml') && $snipeSettings->saml_enabled)
                            <div class="row">
                                <div class="text-right col-md-12">
                                    <a href="{{ route('saml.login')  }}">{{ trans('auth/general.saml_login')  }}</a>
                                </div>
                            </div>
                            @endif
                        </div>
                        <div class="box-footer">
                            @if (config('app.require_saml'))
                                <a class="btn btn-primary btn-block" href="{{ route('saml.login')  }}">
                                    <i class="fas fa-sign-in-alt" style="margin-right: 8px;"></i>
                                    {{ trans('auth/general.saml_login')  }}
                                </a>
                            @else
                                <button class="btn btn-primary btn-block" type="submit">
                                    <i class="fas fa-sign-in-alt" style="margin-right: 8px;"></i>
                                    {{ trans('auth/general.login')  }}
                                </button>
                            @endif

                            @if ($snipeSettings->custom_forgot_pass_url)
                                <div class="col-md-12 text-center" style="padding-top: 20px;">
                                    <a href="{{ $snipeSettings->custom_forgot_pass_url  }}" rel="noopener">
                                        <i class="fas fa-key" style="margin-right: 5px;"></i>
                                        {{ trans('auth/general.forgot_password')  }}
                                    </a>
                                </div>
                            @elseif (!config('app.require_saml'))
                                <div class="col-md-12 text-center" style="padding-top: 20px;">
                                    <a href="{{ route('password.request')  }}">
                                        <i class="fas fa-key" style="margin-right: 5px;"></i>
                                        {{ trans('auth/general.forgot_password')  }}
                                    </a>
                                </div>
                            @endif

                        </div>

                    </div> <!-- end login box -->


                </div> <!-- col-md-4 -->

            </div> <!-- end row -->
        </div> <!-- end container -->
    </form>

    {{-- Footer --}}
    <footer class="login-footer" style="position: fixed; bottom: 0; left: 0; right: 0; background: none; padding: 15px 0; border-top: 1px solid #e9ecef; text-align: center; font-size: 14px; color: #6c757d; backdrop-filter: blur(10px);">
        <div class="container">
            <p style="margin: 0; font-weight: 500;">
              
                Powered by <strong style="color: #3498db;">@Krystal Scanning & Mobility Group</strong>
            </p>
        </div>
    </footer>

@stop

{{-- Add modern login JavaScript --}}
@push('js')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Enhanced form interactions
    const form = document.querySelector('.modern-login-form');
    const inputs = document.querySelectorAll('.form-control');
    const submitBtn = document.querySelector('.btn-primary');
    
    // Add focus effects to inputs
    inputs.forEach(input => {
        input.addEventListener('focus', function() {
            this.parentElement.classList.add('focused');
        });
        
        input.addEventListener('blur', function() {
            if (!this.value) {
                this.parentElement.classList.remove('focused');
            }
        });
        
        // Add typing animation
        input.addEventListener('input', function() {
            this.style.transform = 'scale(1.02)';
            setTimeout(() => {
                this.style.transform = 'scale(1)';
            }, 150);
        });
    });
    
    // Enhanced submit button - removed problematic loading state
    // Form will submit naturally without JavaScript interference
    
    // Add floating animation to logo
    const logo = document.getElementById('login-logo');
    if (logo) {
        logo.addEventListener('mouseenter', function() {
            this.style.animation = 'logoFloat 0.6s ease-in-out infinite';
        });
        
        logo.addEventListener('mouseleave', function() {
            this.style.animation = 'logoFloat 3s ease-in-out infinite';
        });
    }
    
    // Add ripple effect to buttons
    document.querySelectorAll('.btn').forEach(button => {
        button.addEventListener('click', function(e) {
            const ripple = document.createElement('span');
            const rect = this.getBoundingClientRect();
            const size = Math.max(rect.width, rect.height);
            const x = e.clientX - rect.left - size / 2;
            const y = e.clientY - rect.top - size / 2;
            
            ripple.style.width = ripple.style.height = size + 'px';
            ripple.style.left = x + 'px';
            ripple.style.top = y + 'px';
            ripple.classList.add('ripple');
            
            this.appendChild(ripple);
            
            setTimeout(() => {
                ripple.remove();
            }, 600);
        });
    });
    
    // Add keyboard navigation
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Enter' && e.target.classList.contains('form-control')) {
            const inputs = Array.from(document.querySelectorAll('.form-control'));
            const currentIndex = inputs.indexOf(e.target);
            const nextInput = inputs[currentIndex + 1];
            
            if (nextInput) {
                e.preventDefault();
                nextInput.focus();
            } else if (submitBtn) {
                e.preventDefault();
                submitBtn.click();
            }
        }
    });
});

// Password toggle function
function togglePassword() {
    const passwordInput = document.getElementById('password');
    const toggleIcon = document.getElementById('passwordToggleIcon');
    
    if (passwordInput.type === 'password') {
        passwordInput.type = 'text';
        toggleIcon.classList.remove('fa-eye');
        toggleIcon.classList.add('fa-eye-slash');
    } else {
        passwordInput.type = 'password';
        toggleIcon.classList.remove('fa-eye-slash');
        toggleIcon.classList.add('fa-eye');
    }
}

// Add ripple effect CSS
const style = document.createElement('style');
style.textContent = `
    .btn {
        position: relative;
        overflow: hidden;
    }
    
    .ripple {
        position: absolute;
        border-radius: 10%;
        background: rgba(255, 255, 255, 0.3);
        transform: scale(0);
        animation: ripple 0.6s linear;
        pointer-events: none;
    }
    
    @keyframes ripple {
        to {
            transform: scale(4);
            opacity: 0;
        }
    }
    
    .form-group.focused label {
        color: #3498db;
        transform: translateY(-2px);
    }
    
    .form-group.focused .form-control {
        border-color: #3498db;
        box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.1);
    }
`;
document.head.appendChild(style);
</script>
@endpush