@extends('layouts/default')
{{-- Page title --}}
@section('title')
{{ trans('general.dashboard') }}
@parent
@stop


{{-- Page content --}}
@section('content')

@if ($snipeSettings->dashboard_message!='')
<div class="row">
    <div class="col-md-12">
        <div class="box">
            <!-- /.box-header -->
            <div class="box-body">
                <div class="row">
                    <div class="col-md-12">
                        {!!  Helper::parseEscapedMarkedown($snipeSettings->dashboard_message)  !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endif

<div class="row">
  <!-- panel -->
  <div class="col-lg-2 col-xs-6">
      <a href="{{ route('hardware.index') }}">
    <!-- small box -->
    <div class="dashboard small-box bg-teal">
      <div class="inner">
        <h3>{{ number_format(\App\Models\Asset::AssetsForShow()->count()) }}</h3>
        <p>{{ trans('general.assets') }}</p>
      </div>
      <div class="icon" aria-hidden="true">
          <x-icon type="assets" />
      </div>
      @can('index', \App\Models\Asset::class)
        <a href="{{ route('hardware.index') }}" class="small-box-footer">{{ trans('general.view_all') }}
            <x-icon type="arrow-circle-right" />
        </a>
      @endcan
    </div>
      </a>
  </div><!-- ./col -->

  <div class="col-lg-2 col-xs-6">
     <a href="{{ route('licenses.index') }}">
    <!-- small box -->
    <div class="dashboard small-box bg-maroon">
      <div class="inner">
        <h3>{{ number_format($counts['license']) }}</h3>
        <p>{{ trans('general.licenses') }}</p>
      </div>
      <div class="icon" aria-hidden="true">
          <x-icon type="licenses" />
      </div>
        @can('view', \App\Models\License::class)
          <a href="{{ route('licenses.index') }}" class="small-box-footer">{{ trans('general.view_all') }}
              <x-icon type="arrow-circle-right" />
          </a>
        @endcan
    </div>
     </a>
  </div><!-- ./col -->


  <div class="col-lg-2 col-xs-6">
    <!-- small box -->
      <a href="{{ route('accessories.index') }}">
    <div class="dashboard small-box bg-orange">
      <div class="inner">
        <h3> {{ number_format($counts['accessory']) }}</h3>
        <p>{{ trans('general.accessories') }}</p>
      </div>
      <div class="icon" aria-hidden="true">
          <x-icon type="accessories" />
      </div>
      @can('index', \App\Models\Accessory::class)
          <a href="{{ route('accessories.index') }}" class="small-box-footer">{{ trans('general.view_all') }}
              <x-icon type="arrow-circle-right" />
          </a>
      @endcan
    </div>
      </a>
  </div><!-- ./col -->

  <div class="col-lg-2 col-xs-6">
    <!-- small box -->

      <a href="{{ route('consumables.index') }}">
    <div class="dashboard small-box bg-purple">
      <div class="inner">
        <h3> {{ number_format($counts['consumable']) }}</h3>
        <p>{{ trans('general.consumables') }}</p>
      </div>
      <div class="icon" aria-hidden="true">
          <x-icon type="consumables" />
      </div>
      @can('index', \App\Models\Consumable::class)
        <a href="{{ route('consumables.index') }}" class="small-box-footer">{{ trans('general.view_all') }}
            <x-icon type="arrow-circle-right" />
        </a>
      @endcan
    </div>
  </div><!-- ./col -->

  <div class="col-lg-2 col-xs-6">
    <a href="{{ route('components.index') }}">
   <!-- small box -->
   <div class="dashboard small-box bg-yellow">
     <div class="inner">
       <h3>{{ number_format($counts['component']) }}</h3>
       <p>{{ trans('general.components') }}</p>
     </div>
     <div class="icon" aria-hidden="true">
         <x-icon type="components" />
     </div>
       @can('view', \App\Models\License::class)
         <a href="{{ route('components.index') }}" class="small-box-footer">{{ trans('general.view_all') }}
             <x-icon type="arrow-circle-right" />
         </a>
       @endcan
   </div>
    </a>
 </div><!-- ./col -->

 <div class="col-lg-2 col-xs-6">
    <a href="{{ route('users.index') }}">
   <!-- small box -->
   <div class="dashboard small-box bg-light-blue">
     <div class="inner">
       <h3>{{ number_format($counts['user']) }}</h3>
       <p>{{ trans('general.people') }}</p>
     </div>
     <div class="icon" aria-hidden="true">
         <x-icon type="users" />
     </div>
       @can('view', \App\Models\License::class)
         <a href="{{ route('users.index') }}" class="small-box-footer">{{ trans('general.view_all') }}
             <x-icon type="arrow-circle-right" />
         </a>
       @endcan
   </div>
    </a>
 </div><!-- ./col -->

</div>
</div>

@if ($counts['grand_total'] == 0)

    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header with-border">
                    <h2 class="box-title">{{ trans('general.dashboard_info') }}</h2>
                </div>
                <!-- /.box-header -->
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-12">

                            <div class="progress">
                                <div class="progress-bar progress-bar-yellow" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: 60%">
                                    <span class="sr-only">{{ trans('general.60_percent_warning') }}</span>
                                </div>
                            </div>


                            <p><strong>{{ trans('general.dashboard_empty') }}</strong></p>

                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            @can('create', \App\Models\Asset::class)
                            <a class="btn bg-teal" style="width: 100%" href="{{ route('hardware.create') }}">{{ trans('general.new_asset') }}</a>
                            @endcan
                        </div>
                        <div class="col-md-3">
                            @can('create', \App\Models\License::class)
                                <a class="btn bg-maroon" style="width: 100%" href="{{ route('licenses.create') }}">{{ trans('general.new_license') }}</a>
                            @endcan
                        </div>
                        <div class="col-md-3">
                            @can('create', \App\Models\Accessory::class)
                                <a class="btn bg-orange" style="width: 100%" href="{{ route('accessories.create') }}">{{ trans('general.new_accessory') }}</a>
                            @endcan
                        </div>
                        <div class="col-md-3">
                            @can('create', \App\Models\Consumable::class)
                                <a class="btn bg-purple" style="width: 100%" href="{{ route('consumables.create') }}">{{ trans('general.new_consumable') }}</a>
                            @endcan
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@else

<!-- recent activity -->
<div class="row">
  <div class="col-md-8">
    <div class="box">
      <div class="box-header with-border">
        <h2 class="box-title">{{ trans('general.recent_activity') }}</h2>
        <div class="box-tools pull-right">
            <button type="button" class="btn btn-box-tool" data-widget="collapse" aria-hidden="true">
                <x-icon type="minus" />
                <span class="sr-only">{{ trans('general.collapse') }}</span>
            </button>
        </div>
      </div><!-- /.box-header -->
      <div class="box-body">
        <div class="row">
          <div class="col-md-12">
            <div class="table-responsive">

                <table
                    data-cookie-id-table="dashActivityReport"
                    data-height="350"
                    data-pagination="false"
                    data-id-table="dashActivityReport"
                    data-side-pagination="server"
                    data-sort-order="desc"
                    data-sort-name="created_at"
                    id="dashActivityReport"
                    class="table table-striped snipe-table"
                    data-url="{{ route('api.activity.index', ['limit' => 25]) }}">
                    <thead>
                    <tr>
                        <th data-field="icon" data-visible="true" style="width: 40px;" class="hidden-xs" data-formatter="iconFormatter"><span  class="sr-only">{{ trans('admin/hardware/table.icon') }}</span></th>
                        <th class="col-sm-3" data-visible="true" data-field="created_at" data-formatter="dateDisplayFormatter">{{ trans('general.date') }}</th>
                        <th class="col-sm-2" data-visible="true" data-field="admin" data-formatter="usersLinkObjFormatter">{{ trans('general.admin') }}</th>
                        <th class="col-sm-2" data-visible="true" data-field="action_type">{{ trans('general.action') }}</th>
                        <th class="col-sm-3" data-visible="true" data-field="item" data-formatter="polymorphicItemFormatter">{{ trans('general.item') }}</th>
                        <th class="col-sm-2" data-visible="true" data-field="target" data-formatter="polymorphicItemFormatter">{{ trans('general.target') }}</th>
                    </tr>
                    </thead>
                </table>



            </div><!-- /.responsive -->
          </div><!-- /.col -->
          <div class="text-center col-md-12" style="padding-top: 10px;">
            <a href="{{ route('reports.activity') }}" class="btn btn-primary btn-sm" style="width: 100%">{{ trans('general.viewall') }}</a>
          </div>
        </div><!-- /.row -->
      </div><!-- ./box-body -->
    </div><!-- /.box -->
  </div>
  <div class="col-md-4">
        <div class="box box-default">
            <div class="box-header with-border">
                <h2 class="box-title">
                    {{ (\App\Models\Setting::getSettings()->dash_chart_type == 'name') ? trans('general.assets_by_status') : trans('general.assets_by_status_type') }}
                </h2>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse" aria-hidden="true">
                        <x-icon type="minus" />
                        <span class="sr-only">{{ trans('general.collapse') }}</span>
                    </button>
                </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="chart-responsive chart-container">
                            <canvas id="statusPieChart" height="260"></canvas>
                        </div> <!-- ./chart-responsive -->
                    </div> <!-- /.col -->
                </div> <!-- /.row -->
            </div><!-- /.box-body -->
        </div> <!-- /.box -->
  </div>

</div> <!--/row-->
<div class="row">
    <div class="col-md-6">

		@if ($snipeSettings->full_multiple_companies_support=='1')
			 <!-- Companies -->	
			<div class="box box-default">
				<div class="box-header with-border">
					<h2 class="box-title">{{ trans('general.companies') }}</h2>
					<div class="box-tools pull-right">
						<button type="button" class="btn btn-box-tool" data-widget="collapse">
                            <x-icon type="minus" />
							<span class="sr-only">{{ trans('general.collapse') }}</span>
						</button>
					</div>
				</div>
				<!-- /.box-header -->
				<div class="box-body">
					<div class="row">
						<div class="col-md-12">
							<div class="table-responsive">
							<table
									data-cookie-id-table="dashCompanySummary"
									data-height="400"
									data-pagination="true"
									data-side-pagination="server"
									data-sort-order="desc"
									data-sort-field="assets_count"
									id="dashCompanySummary"
									class="table table-striped snipe-table"
									data-url="{{ route('api.companies.index', ['sort' => 'assets_count', 'order' => 'asc']) }}">

								<thead>
								<tr>
									<th class="col-sm-3" data-visible="true" data-field="name" data-formatter="companiesLinkFormatter" data-sortable="true">{{ trans('general.name') }}</th>
									<th class="col-sm-1" data-visible="true" data-field="users_count" data-sortable="true">
                                        <x-icon type="users" />
										<span class="sr-only">{{ trans('general.people') }}</span>
									</th>
									<th class="col-sm-1" data-visible="true" data-field="assets_count" data-sortable="true">
                                        <x-icon type="assets" />
										<span class="sr-only">{{ trans('general.asset_count') }}</span>
									</th>
									<th class="col-sm-1" data-visible="true" data-field="accessories_count" data-sortable="true">
                                        <x-icon type="accessories" />
										<span class="sr-only">{{ trans('general.accessories_count') }}</span>
									</th>
									<th class="col-sm-1" data-visible="true" data-field="consumables_count" data-sortable="true">
                                        <x-icon type="consumables" />
										<span class="sr-only">{{ trans('general.consumables_count') }}</span>
									</th>
									<th class="col-sm-1" data-visible="true" data-field="components_count" data-sortable="true">
                                        <x-icon type="components" />
										<span class="sr-only">{{ trans('general.components_count') }}</span>
									</th>
									<th class="col-sm-1" data-visible="true" data-field="licenses_count" data-sortable="true">
                                        <x-icon type="licenses" />
										<span class="sr-only">{{ trans('general.licenses_count') }}</span>
									</th>
								</tr>
								</thead>
							</table>
							</div>
						</div> <!-- /.col -->
						<div class="text-center col-md-12" style="padding-top: 10px;">
							<a href="{{ route('companies.index') }}" class="btn btn-primary btn-sm" style="width: 100%">{{ trans('general.viewall') }}</a>
						</div>
					</div> <!-- /.row -->

				</div><!-- /.box-body -->
			</div> <!-- /.box -->
		
		@else
			 <!-- Locations -->
			 <div class="box box-default">
				<div class="box-header with-border">
					<h2 class="box-title">{{ trans('general.locations') }}</h2>
					<div class="box-tools pull-right">
						<button type="button" class="btn btn-box-tool" data-widget="collapse">
                            <x-icon type="minus" />
							<span class="sr-only">{{ trans('general.collapse') }}</span>
						</button>
					</div>
				</div>
				<!-- /.box-header -->
				<div class="box-body">
					<div class="row">
						<div class="col-md-12">
							<div class="table-responsive">
							<table
									data-cookie-id-table="dashLocationSummary"
									data-height="400"
									data-pagination="true"
									data-side-pagination="server"
									data-sort-order="desc"
									data-sort-field="assets_count"
									id="dashLocationSummary"
									class="table table-striped snipe-table"
									data-url="{{ route('api.locations.index', ['sort' => 'assets_count', 'order' => 'asc']) }}">

								<thead>
								<tr>
									<th class="col-sm-3" data-visible="true" data-field="name" data-formatter="locationsLinkFormatter" data-sortable="true">{{ trans('general.name') }}</th>
									
									<th class="col-sm-1" data-visible="true" data-field="assets_count" data-sortable="true">
                                        <x-icon type="assets" />
										<span class="sr-only">{{ trans('general.asset_count') }}</span>
									</th>
									<th class="col-sm-1" data-visible="true" data-field="assigned_assets_count" data-sortable="true">
										
										{{ trans('general.assigned') }}
									</th>
									<th class="col-sm-1" data-visible="true" data-field="users_count" data-sortable="true">
                                        <x-icon type="users" />
										<span class="sr-only">{{ trans('general.people') }}</span>
										
									</th>
									
								</tr>
								</thead>
							</table>
							</div>
						</div> <!-- /.col -->
						<div class="text-center col-md-12" style="padding-top: 10px;">
							<a href="{{ route('locations.index') }}" class="btn btn-primary btn-sm" style="width: 100%">{{ trans('general.viewall') }}</a>
						</div>
					</div> <!-- /.row -->

				</div><!-- /.box-body -->
			</div> <!-- /.box -->

		@endif
			
    </div>
    <div class="col-md-6">

        <!-- Categories -->
        <div class="box box-default">
            <div class="box-header with-border">
                <h2 class="box-title">{{ trans('general.asset') }} {{ trans('general.categories') }}</h2>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse">
                        <x-icon type="minus" />
                        <span class="sr-only">{{ trans('general.collapse') }}</span>
                    </button>
                </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                        <table
                                data-cookie-id-table="dashCategorySummary"
                                data-height="400"
                                data-pagination="true"
                                data-side-pagination="server"
                                data-sort-order="desc"
                                data-sort-field="assets_count"
                                id="dashCategorySummary"
                                class="table table-striped snipe-table"
                                data-url="{{ route('api.categories.index', ['sort' => 'assets_count', 'order' => 'asc']) }}">

                            <thead>
                            <tr>
                                <th class="col-sm-3" data-visible="true" data-field="name" data-formatter="categoriesLinkFormatter" data-sortable="true">{{ trans('general.name') }}</th>
                                <th class="col-sm-3" data-visible="true" data-field="category_type" data-sortable="true">
                                    {{ trans('general.type') }}
                                </th>
                                <th class="col-sm-1" data-visible="true" data-field="assets_count" data-sortable="true">
                                    <x-icon type="assets" />
                                    <span class="sr-only">{{ trans('general.asset_count') }}</span>
                                </th>
                                <th class="col-sm-1" data-visible="true" data-field="accessories_count" data-sortable="true">
                                    <x-icon type="licenses" />
                                    <span class="sr-only">{{ trans('general.accessories_count') }}</span>
                                </th>
                                <th class="col-sm-1" data-visible="true" data-field="consumables_count" data-sortable="true">
                                    <x-icon type="consumables" />
                                    <span class="sr-only">{{ trans('general.consumables_count') }}</span>
                                </th>
                                <th class="col-sm-1" data-visible="true" data-field="components_count" data-sortable="true">
                                    <x-icon type="components" />
                                    <span class="sr-only">{{ trans('general.components_count') }}</span>
                                </th>
                                <th class="col-sm-1" data-visible="true" data-field="licenses_count" data-sortable="true">
                                    <x-icon type="licenses" />
                                    <span class="sr-only">{{ trans('general.licenses_count') }}</span>
                                </th>
                            </tr>
                            </thead>
                        </table>
                        </div>
                    </div> <!-- /.col -->
                    <div class="text-center col-md-12" style="padding-top: 10px;">
                        <a href="{{ route('categories.index') }}" class="btn btn-primary btn-sm" style="width: 100%">{{ trans('general.viewall') }}</a>
                    </div>
                </div> <!-- /.row -->

            </div><!-- /.box-body -->
        </div> <!-- /.box -->
    </div>


@endif


@stop

@section('moar_scripts')
@include ('partials.bootstrap-table', ['simple_view' => true, 'nopages' => true])
@stop

@push('js')



<script nonce="{{ csrf_token() }}">
    // ---------------------------
    // - MODERN ASSET STATUS CHART -
    // ---------------------------
      var pieChartCanvas = $("#statusPieChart").get(0).getContext("2d");
      var pieChart = new Chart(pieChartCanvas);
      var ctx = document.getElementById("statusPieChart");
      
      // Modern Chart.js configuration with enhanced styling
      var pieOptions = {
          responsive: true,
          maintainAspectRatio: false,
          plugins: {
              legend: {
                  position: 'bottom',
                  labels: {
                      usePointStyle: true,
                      pointStyle: 'circle',
                      padding: 20,
                      font: {
                          size: 12,
                          weight: '500',
                          family: "'Inter', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif"
                      },
                      color: function(context) {
                          // Use theme-aware colors
                          return getComputedStyle(document.documentElement).getPropertyValue('--text-primary') || '#2c3e50';
                      },
                      generateLabels: function(chart) {
                          const data = chart.data;
                          if (data.labels.length && data.datasets.length) {
                              const dataset = data.datasets[0];
                              const total = dataset.data.reduce((a, b) => a + b, 0);
                              return data.labels.map((label, i) => {
                                  const value = dataset.data[i];
                                  const percentage = Math.round((value / total) * 100);
                                  return {
                                      text: `${label} (${percentage}%)`,
                                      fillStyle: dataset.backgroundColor[i],
                                      strokeStyle: dataset.borderColor ? dataset.borderColor[i] : dataset.backgroundColor[i],
                                      lineWidth: dataset.borderWidth || 0,
                                      pointStyle: 'circle',
                                      hidden: false,
                                      index: i
                                  };
                              });
                          }
                          return [];
                      }
                  }
              },
              tooltip: {
                  enabled: true,
                  backgroundColor: function(context) {
                      // Theme-aware tooltip background
                      const isLight = document.documentElement.getAttribute('data-theme') === 'light';
                      return isLight ? 'rgba(255, 255, 255, 0.95)' : 'rgba(44, 62, 80, 0.95)';
                  },
                  titleColor: function(context) {
                      const isLight = document.documentElement.getAttribute('data-theme') === 'light';
                      return isLight ? '#2c3e50' : '#ffffff';
                  },
                  bodyColor: function(context) {
                      const isLight = document.documentElement.getAttribute('data-theme') === 'light';
                      return isLight ? '#2c3e50' : '#ffffff';
                  },
                  borderColor: function(context) {
                      const isLight = document.documentElement.getAttribute('data-theme') === 'light';
                      return isLight ? '#dee2e6' : '#495057';
                  },
                  borderWidth: 1,
                  cornerRadius: 8,
                  displayColors: true,
                  padding: 12,
                  titleFont: {
                      size: 14,
                      weight: '600',
                      family: "'Inter', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif"
                  },
                  bodyFont: {
                      size: 13,
                      weight: '500',
                      family: "'Inter', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif"
                  },
                  callbacks: {
                      title: function(context) {
                          return context[0].label.split(' (')[0]; // Remove count from title
                      },
                      label: function(context) {
                          const label = context.label || '';
                          const value = context.parsed;
                          const total = context.dataset.data.reduce((a, b) => a + b, 0);
                          const percentage = Math.round((value / total) * 100);
                          return [
                              `${label}`,
                              `Count: ${value}`,
                              `Percentage: ${percentage}%`
                          ];
                      }
                  }
              }
          },
          animation: {
              animateRotate: true,
              animateScale: true,
              duration: 2000,
              easing: 'easeOutQuart',
              onComplete: function() {
                  // Add subtle pulse animation to chart
                  ctx.canvas.style.animation = 'chartPulse 2s ease-in-out infinite';
              }
          },
          interaction: {
              intersect: false,
              mode: 'index'
          },
          elements: {
              arc: {
                  borderWidth: 2,
                  borderColor: function(context) {
                      // Theme-aware border colors
                      const isLight = document.documentElement.getAttribute('data-theme') === 'light';
                      return isLight ? '#ffffff' : '#2c3e50';
                  },
                  hoverBorderWidth: 3,
                  hoverBorderColor: function(context) {
                      const isLight = document.documentElement.getAttribute('data-theme') === 'light';
                      return isLight ? '#007bff' : '#4a90e2';
                  }
              }
          },
          onHover: function(event, elements) {
              event.native.target.style.cursor = elements.length > 0 ? 'pointer' : 'default';
          }
      };

      // Add CSS animation for chart pulse effect
      if (!document.getElementById('chart-animations')) {
          const style = document.createElement('style');
          style.id = 'chart-animations';
          style.textContent = `
              @keyframes chartPulse {
                  0%, 100% { transform: scale(1); }
                  50% { transform: scale(1.02); }
              }
              .chart-container {
                  position: relative;
                  background: linear-gradient(135deg, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0.05) 100%);
                  border-radius: 12px;
                  padding: 20px;
                  box-shadow: 0 4px 20px rgba(0,0,0,0.1);
                  backdrop-filter: blur(10px);
              }
              [data-theme="light"] .chart-container {
                  background: linear-gradient(135deg, rgba(255,255,255,0.8) 0%, rgba(248,249,250,0.6) 100%);
                  box-shadow: 0 4px 20px rgba(0,0,0,0.08);
              }
          `;
          document.head.appendChild(style);
      }

      $.ajax({
          type: 'GET',
          url: '{{ (\App\Models\Setting::getSettings()->dash_chart_type == 'name') ? route('api.statuslabels.assets.byname') : route('api.statuslabels.assets.bytype') }}',
          headers: {
              "X-Requested-With": 'XMLHttpRequest',
              "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr('content')
          },
          dataType: 'json',
          success: function (data) {
              // Enhance the data with modern styling
              if (data.datasets && data.datasets[0]) {
                  const dataset = data.datasets[0];
                  
                  // Add hover effects and modern colors
                  dataset.hoverBackgroundColor = dataset.backgroundColor.map(color => {
                      // Create hover effect by lightening the color
                      return Chart.helpers.color(color).alpha(0.8).rgbString();
                  });
                  
                  // Add border colors for modern look
                  dataset.borderColor = dataset.backgroundColor.map(color => {
                      const isLight = document.documentElement.getAttribute('data-theme') === 'light';
                      return isLight ? '#ffffff' : '#2c3e50';
                  });
                  
                  dataset.borderWidth = 2;
                  dataset.hoverBorderWidth = 3;
              }
              
              var myPieChart = new Chart(ctx, {
                  type: 'pie',
                  data: data,
                  options: pieOptions
              });
              
              // Add click event for interactivity
              ctx.canvas.addEventListener('click', function(event) {
                  const points = myPieChart.getElementsAtEventForMode(event, 'nearest', { intersect: true }, true);
                  if (points.length) {
                      const firstPoint = points[0];
                      const label = myPieChart.data.labels[firstPoint.index];
                      const value = myPieChart.data.datasets[0].data[firstPoint.index];
                      
                      // You can add custom click behavior here
                      console.log(`Clicked on ${label}: ${value} items`);
                  }
              });
          },
          error: function (data) {
              console.error('Error loading chart data:', data);
          },
      });
      
      // Responsive handling with debouncing
      let resizeTimeout;
      var last = document.getElementById('statusPieChart').clientWidth;
      addEventListener('resize', function() {
          clearTimeout(resizeTimeout);
          resizeTimeout = setTimeout(function() {
              var current = document.getElementById('statusPieChart').clientWidth;
              if (current != last) {
                  // Smooth resize instead of page reload
                  if (window.myPieChart) {
                      window.myPieChart.resize();
                  }
              }
              last = current;
          }, 250);
      });
</script>
@endpush
