<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ ($snipeSettings) && ($snipeSettings->site_name) ? $snipeSettings->site_name : 'Mobility-IT' }}</title>

    <link rel="shortcut icon" type="image/ico" href="{{ ($snipeSettings) && ($snipeSettings->favicon!='') ?  Storage::disk('public')->url(e($snipeSettings->favicon)) : config('app.url').'/favicon.ico' }}">
    {{-- stylesheets --}}
    <link rel="stylesheet" href="{{ url(mix('css/dist/all.css')) }}">
    
    {{-- Font Awesome CDN to fix CORS issues --}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" crossorigin="anonymous" referrerpolicy="no-referrer" />

    <script nonce="{{ csrf_token() }}">
        window.snipeit = {
            settings: {
                "per_page": 50
            }
        };
    </script>


    @if (($snipeSettings) && ($snipeSettings->header_color))
        <style>
        .main-header .navbar, .main-header .logo {
        background-color: {{ $snipeSettings->header_color }};
        background: -webkit-linear-gradient(top,  {{ $snipeSettings->header_color }} 0%,{{ $snipeSettings->header_color }} 100%);
        background: linear-gradient(to bottom, {{ $snipeSettings->header_color }} 0%,{{ $snipeSettings->header_color }} 100%);
        border-color: {{ $snipeSettings->header_color }};
        }
        .skin-blue .sidebar-menu > li:hover > a, .skin-blue .sidebar-menu > li.active > a {
        border-left-color: {{ $snipeSettings->header_color }};
        }
        </style>
    @endif

    @if (($snipeSettings) && ($snipeSettings->custom_css))
        <style>
            {!! $snipeSettings->show_custom_css() !!}
        </style>
    @endif

    {{-- Load additional CSS for specific pages --}}
    @stack('css')

    {{-- Force login styles after page load --}}
    @if(request()->is('login') || request()->is('password/reset') || request()->is('password/email'))
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Force apply styles after all CSS has loaded
        setTimeout(function() {
            // Target both login and password reset boxes
            const loginBox = document.querySelector('.login-box');
            const box = document.querySelector('.box');
            
            if (loginBox) {
                loginBox.style.margin = '10% auto';
                loginBox.style.width = '460px';
                loginBox.style.maxWidth = '460px';
                loginBox.style.boxShadow = '9px 9px 9px 9px rgb(32 32 29 / 10%)';
                loginBox.style.borderRadius = '20px';
                loginBox.style.background = '#fff';
                loginBox.style.borderTop = '3px solid #d2d6de';
                loginBox.style.position = 'relative';
                loginBox.style.transition = 'all 0.3s ease';
                loginBox.style.animation = 'smoothFadeIn 0.8s ease-out';
            }
            
            if (box) {
                box.style.margin = '10% auto';
                box.style.width = '460px';
                box.style.maxWidth = '460px';
                box.style.boxShadow = '9px 9px 9px 9px rgb(32 32 29 / 10%)';
                box.style.borderRadius = '20px';
                box.style.background = '#fff';
                box.style.borderTop = '3px solid #d2d6de';
                box.style.position = 'relative';
                box.style.transition = 'all 0.3s ease';
                box.style.animation = 'smoothFadeIn 0.8s ease-out';
            }

            // Fix header and footer border radius
            const boxHeader = document.querySelector('.box-header');
            const boxFooter = document.querySelector('.box-footer');
            const loginBoxBody = document.querySelector('.login-box-body');

            if (boxHeader) {
                boxHeader.style.borderRadius = '20px 20px 0 0';
                boxHeader.style.background = '#f8f9fa';
                boxHeader.style.borderBottom = '1px solid #e1e5e9';
                boxHeader.style.padding = '20px';
            }

            if (boxFooter) {
                boxFooter.style.borderRadius = '0 0 20px 20px';
                boxFooter.style.background = '#f8f9fa';
                boxFooter.style.borderTop = '1px solid #e1e5e9';
                boxFooter.style.padding = '20px';
            }

            if (loginBoxBody) {
                loginBoxBody.style.padding = '20px';
            }

            // Add back button and footer to password reset pages
            if (window.location.pathname.includes('password/reset') || window.location.pathname.includes('password/email')) {
                // Add back button
                const existingBackButton = document.querySelector('.back-button');
                if (!existingBackButton) {
                    const backButton = document.createElement('a');
                    backButton.href = '/login';
                    backButton.className = 'back-button';
                    backButton.innerHTML = '<i class="fas fa-arrow-left"></i>';
                    backButton.title = 'Back to Login';
                    
                    // Add to the login box and ensure proper positioning
                    const loginBox = document.querySelector('.login-box') || document.querySelector('.box');
                    if (loginBox) {
                        // Ensure the box has relative positioning
                        loginBox.style.position = 'relative';
                        loginBox.style.overflow = 'visible';
                        
                        // Add the button
                        loginBox.appendChild(backButton);
                        
                        // Ensure the button is positioned correctly
                        setTimeout(() => {
                            backButton.style.position = 'absolute';
                            backButton.style.top = '10px';
                            backButton.style.right = '10px';
                            backButton.style.zIndex = '1000';
                        }, 10);
                    }
                }

                // Add footer
                const existingFooter = document.querySelector('.login-footer');
                if (!existingFooter) {
                    const footer = document.createElement('footer');
                    footer.className = 'login-footer';
                    footer.style.cssText = 'position: fixed; bottom: 0; left: 0; right: 0; background: none; padding: 15px 0; border-top: 1px solid #e9ecef; text-align: center; font-size: 14px; color: #6c757d; backdrop-filter: blur(10px);';
                    
                    const container = document.createElement('div');
                    container.className = 'container';
                    
                    const paragraph = document.createElement('p');
                    paragraph.style.cssText = 'margin: 0; font-weight: 500;';
                    paragraph.innerHTML = 'Powered by <strong style="color: #3498db;">@Krystal Scanning & Mobility Group</strong>';
                    
                    container.appendChild(paragraph);
                    footer.appendChild(container);
                    document.body.appendChild(footer);
                }
            }
        }, 50);
    });
    </script>
    @endif

    {{-- Force login page styles to override all.css --}}
    @if(request()->is('login') || request()->is('password/reset') || request()->is('password/email'))
    <style>
    /* Override all.css with maximum specificity - using !important and higher specificity */
    body.hold-transition.login-page .box.login-box, 
    body.hold-transition.login-page .box.register-box {
        margin: 10% auto !important;
        width: 460px !important;
        max-width: 460px !important;
        box-shadow: 9px 9px 9px 9px rgb(32 32 29 / 10%) !important;
        border-radius: 20px !important;
        background: #fff !important;
        border-top: 3px solid #d2d6de !important;
        position: relative !important;
        animation: smoothFadeIn 0.8s ease-out !important;
        transition: all 0.3s ease !important;
    }

    body.hold-transition.login-page .box {
        background: #fff !important;
        border-radius: 20px !important;
        border-top: 3px solid #d2d6de !important;
        box-shadow: 9px 9px 9px 9px rgb(32 32 29 / 10%) !important;
        margin-bottom: 20px !important;
        position: relative !important;
        width: 100% !important;
        animation: none !important;
    }

    /* Additional overrides to prevent all.css from overriding */
    body.hold-transition.login-page .login-box {
        margin: 10% auto !important;
        width: 460px !important;
        max-width: 460px !important;
        box-shadow: 9px 9px 9px 9px rgb(32 32 29 / 10%) !important;
        border-radius: 20px !important;
        background: #fff !important;
        border-top: 3px solid #d2d6de !important;
        position: relative !important;
        animation: smoothFadeIn 0.8s ease-out !important;
        transition: all 0.3s ease !important;
    }

    /* Smooth fade-in animation */
    @keyframes smoothFadeIn {
        0% {
            opacity: 0;
            transform: translateY(20px) scale(0.95);
        }
        100% {
            opacity: 1;
            transform: translateY(0) scale(1);
        }
    }

    /* Password reset page styling - multiple selectors to override all.css */
    body.hold-transition.login-page .box.login-box[style*="width: 100%"],
    body.hold-transition.login-page .box.login-box,
    body.hold-transition.login-page .login-box,
    body.hold-transition.login-page .box {
        margin: 10% auto !important;
        width: 460px !important;
        max-width: 460px !important;
        box-shadow: 9px 9px 9px 9px rgb(32 32 29 / 10%) !important;
        border-radius: 20px !important;
        background: #fff !important;
        border-top: 3px solid #d2d6de !important;
        position: relative !important;
        animation: smoothFadeIn 0.8s ease-out !important;
        transition: all 0.3s ease !important;
    }

    /* Override the specific all.css selectors */
    body.hold-transition.login-page .login-box,
    body.hold-transition.login-page .register-box {
        margin: 10% auto !important;
        width: 460px !important;
        max-width: 460px !important;
    }

    body.hold-transition.login-page .box {
        background: #fff !important;
        border-radius: 20px !important;
        border-top: 3px solid #d2d6de !important;
        box-shadow: 9px 9px 9px 9px rgb(32 32 29 / 10%) !important;
        margin-bottom: 20px !important;
        position: relative !important;
        width: 460px !important;
        max-width: 460px !important;
    }

    /* Style password reset header */
    body.hold-transition.login-page .box-header h2.box-title {
        font-size: 24px !important;
        font-weight: 600 !important;
        color: #2c3e50 !important;
        margin: 0 !important;
        text-align: center !important;
    }

    /* Fix border radius for header and footer sections */
    body.hold-transition.login-page .box-header {
        border-radius: 20px 20px 0 0 !important;
        background: #f8f9fa !important;
        border-bottom: 1px solid #e1e5e9 !important;
        padding: 20px !important;
    }

    body.hold-transition.login-page .box-footer {
        border-radius: 0 0 20px 20px !important;
        background: #f8f9fa !important;
        border-top: 1px solid #e1e5e9 !important;
        padding: 20px !important;
    }

    body.hold-transition.login-page .login-box-body {
        padding: 20px !important;
    }

    /* Style password reset form */
    body.hold-transition.login-page .box.login-box .form-group label {
        font-weight: 600 !important;
        color: #2c3e50 !important;
        margin-bottom: 8px !important;
        display: block !important;
        font-size: 14px !important;
    }

    body.hold-transition.login-page .box.login-box .form-control {
        border-radius: 12px !important;
        border: 1px solid #ced4da !important;
        padding: 10px 12px !important;
        font-size: 14px !important;
        transition: all 0.3s ease !important;
    }

    body.hold-transition.login-page .box.login-box .form-control:focus {
        border-color: #3498db !important;
        box-shadow: 0 0 0 0.2rem rgba(52, 152, 219, 0.25) !important;
        outline: 0 !important;
    }

    /* Style password reset button */
    body.hold-transition.login-page .box.login-box .btn-primary {
        background-color: #3498db !important;
        border-color: #3498db !important;
        border-radius: 12px !important;
        padding: 12px 20px !important;
        font-weight: 500 !important;
        transition: all 0.3s ease !important;
        font-size: 16px !important;
    }

    body.hold-transition.login-page .box.login-box .btn-primary:hover {
        background-color: #2980b9 !important;
        border-color: #2980b9 !important;
        transform: translateY(-1px) !important;
    }

    /* Style help links */
    body.hold-transition.login-page .box.login-box a {
        color: #3498db !important;
        text-decoration: none !important;
        font-weight: 500 !important;
        transition: color 0.3s ease !important;
    }

    body.hold-transition.login-page .box.login-box a:hover {
        color: #2980b9 !important;
        text-decoration: underline !important;
    }

    /* Style help text */
    body.hold-transition.login-page .box.login-box .help-block {
        background: #f8f9fa !important;
        border: 1px solid #e9ecef !important;
        border-radius: 8px !important;
        padding: 15px !important;
        margin-top: 10px !important;
        font-size: 14px !important;
        color: #495057 !important;
    }

    /* Style back button */
    body.hold-transition.login-page .back-button {
        position: absolute !important;
        top: 10px !important;
        right: 10px !important;
        background: #6c757d !important;
        color: #fff !important;
        border: none !important;
        border-radius: 50% !important;
        width: 35px !important;
        height: 35px !important;
        display: flex !important;
        align-items: center !important;
        justify-content: center !important;
        font-size: 14px !important;
        cursor: pointer !important;
        transition: all 0.3s ease !important;
        z-index: 10 !important;
        text-decoration: none !important;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1) !important;
    }

    body.hold-transition.login-page .back-button:hover {
        background: #5a6268 !important;
        transform: translateY(-2px) !important;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2) !important;
    }

    body.hold-transition.login-page .back-button:active {
        transform: translateY(0) !important;
    }
    </style>
    @endif

</head>

<body class="hold-transition login-page">

    @if (($snipeSettings) && ($snipeSettings->logo!=''))
        <center>
            <a href="{{ config('app.url') }}"><img id="login-logo" src="{{ Storage::disk('public')->url('').e($snipeSettings->logo) }}"></a>
        </center>
    @endif
  <!-- Content -->
  @yield('content')



    <div class="text-center" style="padding-top: 100px;">
        @if (($snipeSettings) && ($snipeSettings->privacy_policy_link!=''))
        <a target="_blank" rel="noopener" href="{{  $snipeSettings->privacy_policy_link }}" target="_new">{{ trans('admin/settings/general.privacy_policy') }}</a>
    @endif
    </div>

    {{-- Javascript files --}}
    <script src="{{ url(mix('js/dist/all.js')) }}" nonce="{{ csrf_token() }}"></script>


    @stack('js')
</body>

</html>
